<?php $__env->startSection('content'); ?>
    <div class="page-title-area">
        <div class="container">
            <div class="page-title">
                <h1><?php echo e($page_title); ?></h1>
            </div>
        </div>
    </div>





    <div class="affilate-area">
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="tables">
                        <div class="title">
                            <h3>Sell Currency Activity</h3>
                        </div>
                        <div class="chart">
                            <div id="home">
                                <table class="table table-default table-responsive">
                                    <thead>
                                    <tr>
                                        <th scope="col">SL</th>
                                        <th scope="col">Transaction ID</th>
                                        <th scope="col">Quantity</th>
                                        <th scope="col">Price</th>
                                        <th scope="col">Status</th>
                                        <th scope="col">Time</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php if(count($sellCurrency) >0): ?>
                                        <?php $__currentLoopData = $sellCurrency; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>

                                                <td data-label="SL"><?php echo e(++$k); ?></td>
                                                <td data-label="#TRX"><?php echo e(isset($data->trx) ? $data->trx : 'N/A'); ?></td>
                                                <td data-label="Quantity"><i
                                                        class="icofont-money"></i> <span class="strong"><?php echo e(number_format($data->get_amount, $basic->decimal)); ?></span>
                                                    <span class="base-color strong"><?php echo e($data->currency->symbol); ?></span></td>

                                                <td data-label="Price"><i
                                                        class="icofont-money"></i> <span class="strong"><?php echo e(number_format($data->enter_amount, $basic->decimal)); ?></span>
                                                    <span class="base-color strong"><?php echo e($basic->currency); ?></span></td>
                                                <td data-label="Status">
                                                    <?php if($data->status == 1): ?>
                                                        <span class="label label-danger">processing</span>
                                                    <?php elseif($data->status == 2): ?>
                                                        <span class="label label-danger">complete</span>
                                                    <?php elseif($data->status == -2): ?>
                                                        <span class="label label-danger">cancel</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td data-label="Time">
                                                    <?php echo date(' d/M/Y ', strtotime($data->created_at)); ?> </td>

                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="6"> No Data Found !!</td>
                                        </tr>
                                    <?php endif; ?>
                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </div>

                    <div class="tables">
                        <div class="title">
                            <h3>Buy Currency Activity</h3>
                        </div>
                        <div class="chart">
                            <div id="home">
                                <table class="table table-default table-responsive">
                                    <thead>
                                    <tr>
                                        <th scope="col">SL</th>
                                        <th scope="col">Transaction ID</th>
                                        <th scope="col">Quantity</th>
                                        <th scope="col">Price</th>
                                        <th scope="col">Status</th>
                                        <th scope="col">Time</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php if(count($buyMoney) >0): ?>
                                        <?php $__currentLoopData = $buyMoney; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>

                                                <td data-label="SL"><?php echo e(++$k); ?></td>
                                                <td data-label="#TRX"><?php echo e(isset($data->trx) ? $data->trx : 'N/A'); ?></td>
                                                <td data-label="Quantity"><i
                                                        class="icofont-money base-color "></i> <span class="strong"><?php echo e(number_format($data->get_amount, $basic->decimal)); ?></span>
                                                    <span class="base-color strong"><?php echo e($data->currency->symbol); ?></span></td>

                                                <td data-label="Price"><i
                                                        class="icofont-money base-color"></i> <span class="strong"><?php echo e(number_format($data->enter_amount, $basic->decimal)); ?></span>
                                                    <span class="base-color strong"><?php echo e($basic->currency); ?></span></td>
                                                <td data-label="Status">
                                                    <?php if($data->status == 1): ?>
                                                        <span class="label label-danger">processing</span>
                                                    <?php elseif($data->status == 2): ?>
                                                        <span class="label label-danger">complete</span>
                                                    <?php elseif($data->status == -2): ?>
                                                        <span class="label label-danger">cancel</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td data-label="Time">
                                                    <?php echo date(' d/M/Y ', strtotime($data->created_at)); ?> </td>

                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="6"> No Data Found !!</td>
                                        </tr>
                                    <?php endif; ?>
                                    </tbody>
                                </table>

                            </div>

                        </div>
                    </div>

                    <div class="tables">
                        <div class="title">
                            <h3>Exchange Currency Activity</h3>
                        </div>
                        <div class="chart">
                            <div id="home">
                                <table class="table table-default table-responsive">
                                    <thead>
                                    <tr>
                                        <th scope="col">Transaction ID</th>
                                        <th scope="col">Exchange From</th>
                                        <th scope="col">Exchange To</th>
                                        <th scope="col">Status</th>
                                        <th scope="col">Time</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php if(count($exchange) >0): ?>
                                        <?php $__currentLoopData = $exchange; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td data-label="#TRX"><?php echo e(isset($data->trx) ? $data->trx : 'N/A'); ?></td>
                                                <td data-label="Exchange From"><i class="icofont-money base-color"></i> <span class="strong"><?php echo e($data->from_amount); ?></span> <span class="base-color strong"><?php echo e($data->fromCurrency->symbol); ?></span></td>

                                                <td data-label="Exchange To">
                                                    <i class="icofont-money base-color"></i> <span class="strong"><?php echo e($data->receive_amount); ?> </span> <span class="base-color strong"><?php echo e($data->toCurrency->symbol); ?></span></td>
                                                <td data-label="Status">
                                                    <?php if($data->status == 1): ?>
                                                        <span class="label label-danger">processing</span>
                                                    <?php elseif($data->status == 2): ?>
                                                        <span class="label label-danger">complete</span>
                                                    <?php elseif($data->status == -2): ?>
                                                        <span class="label label-danger">rejected</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td data-label="Time">
                                                    <?php echo date(' d/M/Y ', strtotime($data->created_at)); ?> </td>

                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="6"> No Data Found !!</td>
                                        </tr>
                                    <?php endif; ?>
                                    </tbody>
                                </table>

                            </div>

                        </div>
                    </div>


                </div>
            </div>
        </div>
    </div>







<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('user', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>